<?PHP
include_once "wsenv.php";
include_once "websync.inc";

define("START_OF_FILE", '<START_OF_FILE>');
define("END_OF_FILE", '<END_OF_FILE>');
define("END_OF_LINE", '<END>');
define("CR_LF", "\n");


function AppendLicenceFile($licenceNo) {

    $licenceError = GetLicenceErrorDesc($licenceNo);
    if (!empty($licenceError)) {
	applog($licenceError);
	echo $licenceError;
	return;
    }
    
    $fileName = GetLicenceFileName($licenceNo);
    $lines = file($fileName);
    
    echo START_OF_FILE.CR_LF;
    foreach ($lines as $line)
	echo trim($line).END_OF_LINE.CR_LF;
    echo END_OF_FILE.CR_LF;
	
    applog('Odczyt pliku licencji '.$licenceNo);

}

function GetLicenceErrorDesc($licenceNo){
    $currLen = strlen($licenceNo);
    if ($currLen != 12)
	return "Niepoprawna dlugosc numeru.";

    // czy licencja zawiera jedynie hexadecymalne znaki
    if (!preg_match('/^[A-Fa-f0-9]{0,}$/', $licenceNo))
	return "Niepoprawne znaki w numerze licencji.";
	
    $licenceDir = $GLOBALS["LICDIR"];    
    if (!file_exists($licenceDir))
       return "Brak katalogu licencji.";
       
    $licenceFile =  GetLicenceFileName($licenceNo);
    if (!file_exists($licenceFile))
	return "Brak licencji.";
    
    return  "";
}

function GetLicenceFileName($licenceNo) {
    $licenceDir = $GLOBALS["LICDIR"];
    $licenceFile = $licenceDir.$GLOBALS['DIRECTORY_SEPARATOR'].'licence'.strtoupper($licenceNo).'.lic';
    return $licenceFile;
}


?>
